/**
 * @name Include header files only
 * @description The #include pre-processor directive should only be used to include header files.
 * @kind problem
 * @problem.severity recommendation
 * @precision high
 * @id cpp/include-non-header
 * @tags maintainability
 *       modularity
 *       readability
 *       external/jsf
 */

import cpp
import semmle.code.cpp.AutogeneratedFile

from Include i, File f, string extension
where
  f = i.getIncludedFile() and
  extension = f.getExtension().toLowerCase() and
  extension != "def" and
  extension != "inc" and
  extension != "inl" and
  extension != "tcc" and
  extension != "tpp" and
  extension != "txx" and
  extension != "xpm" and
  not f instanceof AutogeneratedFile and
  not f instanceof HeaderFile
select i, "The #include pre-processor directive should only be used to include header files."
